const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_detail13', {
    SerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Time: {
      type: DataTypes.TIME,
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    Min: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Avg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    MaxTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    AvgTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    TestResult: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    NoOfSample: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Deviation: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    DT_Time: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    }
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_detail13',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK__tbl_batc__7982B60053CCC66A",
        unique: true,
        fields: [
          { name: "SerNo" },
        ]
      },
    ]
  });
};
